import * as React from 'react';
import { EditableFieldBaseComponent } from '../field-base-component';
import type { NestedFieldsAdditionalProperties } from '../field-base-component-types';
import type { BinaryValue } from '../../types';
import type { FormDesignerComponentProps, FormDesignerDecoratorProperties } from './form-designer-types';
export interface FormDesignerComponentState {
    headerValue: string;
    footerValue: string;
}
export declare class FormDesignerComponent extends EditableFieldBaseComponent<FormDesignerDecoratorProperties, BinaryValue, NestedFieldsAdditionalProperties, FormDesignerComponentState> {
    private actionSubscription;
    constructor(props: FormDesignerComponentProps);
    componentWillReceiveProps(nextProps: Readonly<FormDesignerComponentProps>): void;
    componentWillUnmount(): void;
    private readonly onReadyEvent;
    private readonly onChange;
    private readonly onHeaderChange;
    private readonly onFooterChange;
    private readonly getObjectDetails;
    private readonly onEditorReady;
    private readonly onObjectInsert;
    private readonly getDocumentParameters;
    private readonly onDisplayToast;
    private readonly contextProvider;
    render(): React.ReactNode;
}
export declare const ConnectedFormDesignerComponent: import("react-redux").ConnectedComponent<typeof FormDesignerComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<FormDesignerComponent> | undefined;
    contextType?: import("../../../types").ContextType | undefined;
    bind?: import("../reference/reference-types").PropertyValueType<import("@sage/xtrem-client").ClientNode | any>;
    screenId: string;
    parentElementId?: string | undefined;
    level?: number | undefined;
    elementId: string;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    isUsingInfiniteScroll?: boolean | undefined;
    contextNode?: import("../../../types").NodePropertyType | undefined;
    recordContext?: any;
    columnDefinition?: any;
    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
    isNested?: boolean | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export default ConnectedFormDesignerComponent;
//# sourceMappingURL=form-designer-component.d.ts.map