import { addColumnsToProperties, addDisabledToProperties, addMaxLengthToProperties, addNodeToProperties, addValueFieldToProperties, } from '../../../utils/data-type-utils';
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { FilterSelectControlObject } from '../../control-objects';
import { FieldKey } from '../../types';
export var FilterSelectDecoratorPropertiesKeys;
(function (FilterSelectDecoratorPropertiesKeys) {
    FilterSelectDecoratorPropertiesKeys["onCloseLookupDialog"] = "onCloseLookupDialog";
    FilterSelectDecoratorPropertiesKeys["onOpenLookupDialog"] = "onOpenLookupDialog";
})(FilterSelectDecoratorPropertiesKeys || (FilterSelectDecoratorPropertiesKeys = {}));
class FilterSelectDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = FilterSelectControlObject;
    }
    getComponentPropertiesFromDataType(dataType, propertyDetails) {
        const properties = {};
        addNodeToProperties({ dataType, propertyDetails, properties });
        addColumnsToProperties({
            dataType,
            propertyDetails,
            properties,
            dataTypes: this.dataTypes,
            nodeTypes: this.nodeTypes,
        });
        addValueFieldToProperties({
            dataType,
            propertyDetails,
            properties,
        });
        addMaxLengthToProperties({
            dataType,
            propertyDetails,
            properties,
        });
        addDisabledToProperties({
            propertyDetails,
            dataType,
            properties,
        });
        return properties;
    }
}
/**
 * Initializes the decorated member as a [FilterSelect]{@link FilterSelectControlObject} field with the provided properties.
 *
 * @param properties The properties that the [FilterSelect]{@link FilterSelectControlObject} field will be initialized with.
 */
export function filterSelectField(properties) {
    return standardDecoratorImplementation(properties, FilterSelectDecorator, FieldKey.FilterSelect, true);
}
export function filterSelectFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=filter-select-decorator.js.map