/**
 * @packageDocumentation
 * @module root
 */
import type { ClientNode } from '@sage/xtrem-client';
import type { IconType } from 'carbon-react/esm/components/icon/icon-type';
import type { GraphQLFilter } from '../../../service/graphql-utils';
import type { ScreenBase } from '../../../service/screen-base';
import type { FieldComponentProps, FieldKey } from '../../types';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import type { FilterSelectProperties } from './filter-select-types';
/**
 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values or sets a new value to be
 * saved later. The type of GraphQL object must be specified through the 'node' property, while the 'valueField' and
 * 'helperTextField' properties define which properties of the GraphQL object will be displayed in the field and will
 * be matched against the user provided text.
 */
export declare class FilterSelectControlObject<ReferencedItemType extends ClientNode = any, CT extends ScreenBase = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.FilterSelect, FieldComponentProps<FieldKey.FilterSelect>> {
    static readonly defaultUiProperties: Partial<FilterSelectProperties>;
    /** Graphql filter that will restrict the results of the reference field */
    get filter(): GraphQLFilter<ReferencedItemType> | ((this: CT) => GraphQLFilter<ReferencedItemType>) | undefined;
    /** Graphql filter that will restrict the results of the reference field */
    set filter(filter: GraphQLFilter<ReferencedItemType> | ((this: CT) => GraphQLFilter<ReferencedItemType>) | undefined);
    /** The helper text underneath the field */
    helperText?: string;
    /** Icon of the input field. It will be placed on the right side. */
    icon?: IconType;
    /** Color of the icon, only supported in tile containers */
    iconColor?: string;
    /** Indicator, whether field can generate value for to be created node */
    isNewEnabled?: boolean;
    /** Indicator, whether sounds play on successful/erroneous selection */
    isSoundDisabled?: boolean;
    /** The maximum length of the filter select field value */
    maxLength?: number;
    /** The minimum length of the filter select field value */
    minLength?: number;
    /** Placeholder to be displayed in the field body */
    placeholder?: string;
    /** Lookup Dialog title **/
    lookupDialogTitle?: string;
    /** Refetches data from the server */
    refresh(): Promise<void>;
    /** Moves the browser focus to this field */
    focus(): void;
    fetchSuggestions(searchText: string): Promise<Partial<ReferencedItemType>[]>;
}
//# sourceMappingURL=filter-select-control-object.d.ts.map