import * as React from 'react';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
const ConnectedFilterSelectComponent = React.lazy(() => import('./filter-select-component'));
export function AsyncConnectedFilterSelectComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedFilterSelectComponent, { ...props })));
}
const FilterSelectComponent = React.lazy(() => import('./filter-select-component').then(c => ({ default: c.FilterSelectComponent })));
export function AsyncFilterSelectComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(FilterSelectComponent, { ...props })));
}
//# sourceMappingURL=async-filter-select-component.js.map