import * as React from 'react';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
const ConnectedFilterEditorComponent = React.lazy(() => import('./filter-editor-component'));
export function AsyncConnectedFilterEditorComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedFilterEditorComponent, { ...props })));
}
const FilterEditorComponent = React.lazy(() => import('./filter-editor-component').then(c => ({ default: c.FilterEditorComponent })));
export function AsyncFilterEditorComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(FilterEditorComponent, { ...props })));
}
//# sourceMappingURL=async-filter-editor-component.js.map