/**
 * @packageDocumentation
 * @module root
 * */
import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { FieldKey } from '../../types';
import { FileControlObject } from './file-control-object';
class FileDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._controlObjectConstructor = FileControlObject;
        this._layout = AbstractFieldLayoutBuilder;
    }
}
/**
 * Initializes the decorated member as a [File]{@link FileControlObject} field with the provided properties
 *
 * @param properties The properties that the [File]{@link FileControlObject} field will be initialized with
 */
export function fileField(properties) {
    return standardDecoratorImplementation(properties, FileDecorator, FieldKey.File);
}
export function fileFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=file-decorator.js.map