/**
 * @packageDocumentation
 * @module root
 * */
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ChangeableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { FileDepositDecoratorProperties } from './file-deposit-types';
/**
 * Initializes the decorated member as a [File]{@link FileDepositControlObject} field with the provided properties
 *
 * @param properties The properties that the [File]{@link FileDepositControlObject} field will be initialized with
 */
export declare function fileDepositField<T extends ScreenExtension<T>>(properties: FileDepositDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function fileDepositFieldOverride<T extends ScreenExtension<T>>(properties: ChangeableOverrideDecoratorProperties<FileDepositDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=file-deposit-decorator.d.ts.map