/**
 * @packageDocumentation
 * @module root
 * */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { EditableFieldControlObject } from '../../editable-field-control-object';
import { ControlObjectProperty } from '../../property-decorators/control-object-property-decorator';
/**
 * [Field]{@link EditableFieldControlObject} that holds a file stream value
 */
export class FileDepositControlObject extends EditableFieldControlObject {
    static { this.defaultUiProperties = {
        ...EditableFieldControlObject.defaultUiProperties,
    }; }
    /** Moves the browser focus to this field */
    focus() {
        this._focus();
    }
}
__decorate([
    ControlObjectProperty()
    /** File types that can be uploaded. Can be either audio/*, video/*, image/*, an extension name starting with '.'
     *  or a valid media type. Look at [IANA Media Types](https://www.iana.org/assignments/media-types/media-types.xhtml). for a complete list of standard media types.
     * It is possible to set more than one file type, simply by defining them separated by a comma.
     */
], FileDepositControlObject.prototype, "fileTypes", void 0);
//# sourceMappingURL=file-deposit-control-object.js.map