import * as React from 'react';
import * as xtremRedux from '../../redux';
import type { ValidationResult } from '../../service/screen-base-definition';
import { ContextType } from '../../types';
import type { ValueOrCallbackKeysExtractor, ValueOrCallbackReturnExtractor } from '../../utils/types';
import type { UiComponentProperties } from '../abstract-ui-control-object';
import type { EditableFieldProperties } from '../editable-field-control-object';
import type { ErrorableFieldProperties } from '../errorable-field-control-object';
import type { ReadonlyFieldProperties } from '../readonly-field-control-object';
import type { BaseEditableComponentProperties, BaseErrorableComponentProperties, BaseReadonlyComponentProperties, EditableFieldComponentProperties, FieldBaseComponentProperties, FieldComponentExternalProperties, NestedFieldsAdditionalProperties, ReadonlyFieldComponentProperties } from './field-base-component-types';
interface BaseAttributesDivWrapper {
    'data-testid': string;
    className: string;
}
export declare class FieldBaseComponent<CoreProps extends BaseReadonlyComponentProperties<FieldUiProperties, FieldValue, AdditionalProperties> & NestedFieldsAdditionalProperties, FieldUiProperties extends ReadonlyFieldProperties, FieldValue, AdditionalProperties = {}, ComponentState = {}> extends React.Component<CoreProps & NestedFieldsAdditionalProperties, ComponentState> {
    protected componentRef: React.RefObject<HTMLDivElement>;
    shouldComponentUpdate(nextProps: CoreProps, nextState: any): boolean;
    componentDidUpdate(prevProps: CoreProps): void;
    /**
     * @deprecated Use handleChange from abstract-fields-utils instead of this.
     */
    handleChange(elementId: string, value: any, // TODO Type this properly
    setFieldValue: (bind: string, value: any) => Promise<void>, validate?: (bind: string, value: any) => Promise<ValidationResult[] | undefined>, onChange?: () => void): void;
    protected getResolvedProperty<K extends ValueOrCallbackKeysExtractor<FieldUiProperties>>(key: K, skipHexFormat?: boolean): ValueOrCallbackReturnExtractor<FieldUiProperties, K>;
    /**
     * 'data-label' is used for alignment purposes only
     *
     * @private
     * @memberof FieldBaseComponent
     */
    private readonly getDataLabel;
    private readonly getComponentClass;
    getBaseAttributesDivWrapper: (componentName: string, specificClassNames: string, contextType?: ContextType, rowValue?: any, isNested?: boolean) => BaseAttributesDivWrapper;
    getFocusableElement(fieldContainer: HTMLElement): HTMLElement | null;
    getValue: () => FieldValue | undefined;
    getClickHandler: () => () => void;
    getTitle(): string;
    triggerChangeListener: (newValue?: any) => void;
    isDisabled(): boolean;
}
export declare class ReadonlyFieldBaseComponent<FieldUiProperties extends ReadonlyFieldProperties, FieldValue, AdditionalProperties = {}, ComponentState = {}> extends FieldBaseComponent<BaseReadonlyComponentProperties<FieldUiProperties, FieldValue, AdditionalProperties>, FieldUiProperties, FieldValue, AdditionalProperties, ComponentState> {
    shouldComponentUpdate(nextProps: FieldBaseComponentProperties<FieldUiProperties, FieldValue, AdditionalProperties>, nextState: any): boolean;
}
export declare class EditableFieldBaseComponent<FieldUiProperties extends EditableFieldProperties, FieldValue, AdditionalProperties = {}, ComponentState = {}> extends FieldBaseComponent<BaseEditableComponentProperties<FieldUiProperties, FieldValue, AdditionalProperties>, FieldUiProperties, FieldValue, AdditionalProperties, ComponentState> {
    shouldComponentUpdate(nextProps: FieldBaseComponentProperties<FieldUiProperties, FieldValue, AdditionalProperties>, nextState: any): boolean;
    isReadOnly(): boolean;
}
export declare class ErrorableFieldBaseComponent<FieldUiProperties extends ErrorableFieldProperties, FieldValue, AdditionalProperties = {}, ComponentState = {}> extends FieldBaseComponent<BaseErrorableComponentProperties<FieldUiProperties, FieldValue, AdditionalProperties>, FieldUiProperties, FieldValue, AdditionalProperties, ComponentState> {
    shouldComponentUpdate(nextProps: FieldBaseComponentProperties<FieldUiProperties, FieldValue, AdditionalProperties>, nextState: any): boolean;
    isReadOnly(): boolean;
}
export declare const mapReadonlyStateToProps: () => (state: xtremRedux.XtremAppState, props: FieldComponentExternalProperties) => ReadonlyFieldComponentProperties<UiComponentProperties, any>;
export declare const mapStateToProps: () => (state: xtremRedux.XtremAppState, props: FieldComponentExternalProperties) => EditableFieldComponentProperties<UiComponentProperties, any>;
export declare const mapDispatchToProps: <Properties extends UiComponentProperties = UiComponentProperties>(callback?: (dispatch: xtremRedux.AppThunkDispatch, props: FieldComponentExternalProperties) => Partial<EditableFieldComponentProperties<Properties, any>>) => (dispatch: xtremRedux.AppThunkDispatch, props: FieldComponentExternalProperties) => Partial<EditableFieldComponentProperties<Properties, any>>;
export {};
//# sourceMappingURL=field-base-component.d.ts.map