import React from 'react';
import type { PageActionControlObject } from '../control-objects';
import type { ScreenExtension } from '../../types';
import type { ScreenBase } from '../../service/screen-base';
import type { IconType } from 'carbon-react/esm/components/icon';
export interface AdditionalFieldAction<CT extends ScreenExtension<CT> = ScreenBase> {
    title: string;
    onClick: (this: CT) => void;
    icon: IconType;
    id: string;
}
interface FieldActionExternalProps {
    screenId: string;
    fieldId: string;
    isDisabled?: boolean;
    additionalFieldActions?: AdditionalFieldAction[];
}
interface FieldActionProps extends FieldActionExternalProps {
    fieldActionsMap?: PageActionControlObject[];
}
declare function FieldActions(props: FieldActionProps): React.ReactElement | null;
declare const _default: import("react-redux").ConnectedComponent<typeof FieldActions, {
    screenId: string;
    fieldId: string;
    isDisabled?: boolean | undefined;
    additionalFieldActions?: AdditionalFieldAction[] | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export default _default;
//# sourceMappingURL=field-actions-component.d.ts.map