import ButtonMinor from 'carbon-react/esm/components/button-minor';
import * as React from 'react';
import { localize } from '../../../service/i18n-service';
import Textbox from 'carbon-react/esm/components/textbox';
import Icon from 'carbon-react/esm/components/icon';
export function DynamicSelectInput({ disabled, error, helperText, icon, info, inputRef, label, lookupButtonEvents, mode = 'select', onBlur, onChange, onClick, onFocus, onKeyDown, readOnly, size, value, warning, }) {
    const children = (React.createElement("div", { className: "e-ui-select-lookup-button" },
        React.createElement(ButtonMinor, { ...lookupButtonEvents, buttonType: "tertiary", "data-component-size": size, "data-testid": "e-ui-dynamic-select-open-button", iconType: icon, size: "medium", "aria-label": localize('@sage/xtrem-ui/open-dynamic-select', 'Open list'), iconTooltipMessage: localize('@sage/xtrem-ui/open-dynamic-select', 'Open list') })));
    const getWrapperClassNames = () => {
        const classes = ['e-ui-select-input-wrapper'];
        if (!readOnly && !disabled) {
            classes.push('e-ui-select-search-override');
        }
        return classes.join(' ');
    };
    const getClassNames = () => {
        const classes = ['e-field-select-input-text'];
        if (error) {
            classes.push('e-field-error-message-carbon');
        }
        return classes.join(' ');
    };
    return (React.createElement("div", { className: getWrapperClassNames() },
        React.createElement(Textbox, { onChange: onChange, onBlur: onBlur, m: 0, "aria-label": label, className: getClassNames(), "data-testid": "e-ui-select-input", disabled: disabled, error: disabled ? undefined : error, warning: disabled ? undefined : warning, info: disabled ? undefined : info, onFocus: onFocus, onClick: onClick, onKeyDown: onKeyDown, fieldHelp: helperText, id: "e-ui-select-input", ref: inputRef, readOnly: mode === 'select' ? true : readOnly, label: label, size: size, validationOnLabel: true, value: value },
            mode === 'select' && (React.createElement("span", { "data-testid": "e-ui-dynamic-input-chevron", className: "e-ui-select-inline-dropdown", ...lookupButtonEvents },
                React.createElement(Icon, { type: "caret_down" }))),
            mode === 'input' && children)));
}
//# sourceMappingURL=dynamic-select-input.js.map