import * as React from 'react';
import type { IconType } from '@sage/xtrem-shared';
import type { SizeOptions } from 'carbon-react/esm/components/button/button.component';
export declare function DynamicSelectInput({ disabled, error, helperText, icon, info, inputRef, label, lookupButtonEvents, mode, onBlur, onChange, onClick, onFocus, onKeyDown, readOnly, size, value, warning, }: {
    disabled?: boolean;
    error?: string;
    helperText?: string;
    icon: IconType;
    info?: string;
    inputRef: React.RefObject<HTMLInputElement>;
    label: string;
    mode: 'select' | 'input';
    onBlur?: (ev: React.FocusEvent<HTMLInputElement>) => void;
    onChange?: (ev: React.ChangeEvent<HTMLInputElement>) => void;
    onClick?: (ev: React.MouseEvent<HTMLButtonElement>) => void;
    onFocus?: (ev: React.FocusEvent<HTMLInputElement>) => void;
    onKeyDown?: (ev: React.KeyboardEvent<HTMLInputElement>) => void;
    readOnly?: boolean;
    size?: SizeOptions;
    value: string | undefined;
    warning?: string;
    lookupButtonEvents: {
        onFocus: () => void;
        onBlur: () => void;
        onClick: () => void;
        lookupIconId: string;
        lookupButtonRef: React.RefObject<HTMLButtonElement>;
    };
}): React.ReactElement;
//# sourceMappingURL=dynamic-select-input.d.ts.map