import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { FieldKey } from '../../types';
import { DynamicSelectControlObject } from './dynamic-select-control-object';
class DynamicSelectDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = DynamicSelectControlObject;
    }
}
/**
 * Initializes the decorated member as a [DynamicSelectDecorator]{@link DynamicSelectDecoratorControlObject} field with the provided properties.
 *
 * @param properties The properties that the [DynamicSelectDecorator]{@link DynamicSelectDecoratorControlObject} field will be initialized with.
 */
export function dynamicSelectField(properties) {
    return standardDecoratorImplementation(properties, DynamicSelectDecorator, FieldKey.DynamicSelect);
}
export function dynamicSelectFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=dynamic-select-decorator.js.map