import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ChangeableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { DynamicSelectDecoratorProperties } from './dynamic-select-types';
/**
 * Initializes the decorated member as a [DynamicSelectDecorator]{@link DynamicSelectDecoratorControlObject} field with the provided properties.
 *
 * @param properties The properties that the [DynamicSelectDecorator]{@link DynamicSelectDecoratorControlObject} field will be initialized with.
 */
export declare function dynamicSelectField<T extends ScreenExtension<T>>(properties: DynamicSelectDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function dynamicSelectFieldOverride<T extends ScreenExtension<T>>(properties: ChangeableOverrideDecoratorProperties<DynamicSelectDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=dynamic-select-decorator.d.ts.map