/**
 * @packageDocumentation
 * @module root
 */
import type { ClientNode } from '@sage/xtrem-client';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
import type { DynamicSelectProperties } from './dynamic-select-types';
import type { SelectItem } from '../../ui/select/select-component';
/**
 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values.
 */
export declare class DynamicSelectControlObject<NodeType extends ClientNode = any, CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.DynamicSelect, FieldComponentProps<FieldKey.DynamicSelect>> {
    static readonly defaultUiProperties: Partial<DynamicSelectProperties>;
    /** The helper text underneath the field */
    helperText?: string;
    /** The helper text underneath the field */
    placeholder?: string;
    /** The mode Dynamic Select will be set */
    mode?: 'select' | 'input';
    options?: SelectItem[];
    focus(): void;
}
//# sourceMappingURL=dynamic-select-control-object.d.ts.map