import * as React from 'react';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
const ConnectedDynamicSelectComponent = React.lazy(() => import('./dynamic-select-component'));
export function AsyncConnectedDynamicSelectComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader, bodyHeight: "200px" }) },
        React.createElement(ConnectedDynamicSelectComponent, { ...props })));
}
const DynamicSelectComponent = React.lazy(() => import('./dynamic-select-component').then(e => ({ default: e.DynamicSelectComponent })));
export function AsyncDynamicSelectComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: false, bodyHeight: "200px" }) },
        React.createElement(DynamicSelectComponent, { ...props })));
}
//# sourceMappingURL=async-dynamic-select-component.js.map