var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { showToast } from '../../../service/toast-service';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import { ControlObjectProperty } from '../../property-decorators/control-object-property-decorator';
import { convertDeepBindToPathNotNull } from '../../../utils/nested-field-utils';
/**
 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values.
 */
export class DynamicPodControlObject extends EditableFieldControlObject {
    static { this.defaultUiProperties = {
        ...EditableFieldControlObject.defaultUiProperties,
    }; }
    /** Graphql filter that will restrict the results of the reference field */
    get filter() {
        return resolveByValue({
            fieldValue: undefined,
            propertyValue: this.getUiComponentProperty('filter'),
            rowValue: undefined,
            screenId: this.screenId,
            skipHexFormat: true,
        });
    }
    /** Graphql filter that will restrict the results of the reference field */
    set filter(filter) {
        this.setUiComponentProperties('filter', filter);
        this.refresh().catch(() => {
            /* Intentional fire and forget */
        });
    }
    /** The GraphQL node that the field suggestions will be fetched from */
    get node() {
        return String(this.getUiComponentProperty('node'));
    }
    async refresh() {
        await this._refresh({ keepPageInfo: true }).catch(e => {
            showToast(e.message || e, { type: 'warning' });
        });
    }
    focus() {
        this._focus();
    }
    /** Set a new list of nested fields to be show in the pod  */
    setNestedFields(nestedFields) {
        this.setUiComponentProperties('columns', nestedFields);
    }
    /** Add a individual nested field to the end of pod */
    addNestedField(nestedField) {
        const columns = this.getUiComponentProperty('columns') || [];
        this.setUiComponentProperties('columns', [...columns, nestedField]);
    }
    /** Remove the nested field by the bind */
    removeNestedField(bind) {
        const columns = [...(this.getUiComponentProperty('columns') || [])];
        columns.filter(c => {
            return convertDeepBindToPathNotNull(c.properties.bind) !== convertDeepBindToPathNotNull(bind);
        });
        this.setUiComponentProperties('columns', columns);
    }
    /** Remove all nested fields */
    removeAllNestedFields() {
        this.setUiComponentProperties('columns', []);
    }
}
__decorate([
    ControlObjectProperty()
    /** The helper text underneath the field */
], DynamicPodControlObject.prototype, "helperText", void 0);
__decorate([
    ControlObjectProperty()
    /** Whether the value of the pod can be unset */
], DynamicPodControlObject.prototype, "canRemove", void 0);
__decorate([
    ControlObjectProperty()
    /** Placeholder to be displayed in the field body */
], DynamicPodControlObject.prototype, "placeholder", void 0);
//# sourceMappingURL=dynamic-pod-control-object.js.map