/**
 * @packageDocumentation
 * @module root
 */
import type { ClientNode } from '@sage/xtrem-client';
import type { GraphQLFilter } from '../../../service/graphql-utils';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
import type { DynamicPodProperties } from './dynamic-pod-types';
import type { NestedField } from '../../nested-fields';
/**
 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values.
 */
export declare class DynamicPodControlObject<NodeType extends ClientNode = any, CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.DynamicPod, FieldComponentProps<FieldKey.DynamicPod>> {
    static readonly defaultUiProperties: Partial<DynamicPodProperties>;
    /** Graphql filter that will restrict the results of the reference field */
    get filter(): GraphQLFilter<NodeType> | undefined;
    /** Graphql filter that will restrict the results of the reference field */
    set filter(filter: GraphQLFilter<NodeType> | undefined);
    /** The GraphQL node that the field suggestions will be fetched from */
    get node(): string;
    /** The helper text underneath the field */
    helperText?: string;
    /** Whether the value of the pod can be unset */
    canRemove?: boolean;
    /** Placeholder to be displayed in the field body */
    placeholder?: string;
    refresh(): Promise<void>;
    focus(): void;
    /** Set a new list of nested fields to be show in the pod  */
    setNestedFields(nestedFields: NestedField<any, any>[]): void;
    /** Add a individual nested field to the end of pod */
    addNestedField(nestedField: NestedField<any, any>): void;
    /** Remove the nested field by the bind */
    removeNestedField(bind: string | Object): void;
    /** Remove all nested fields */
    removeAllNestedFields(): void;
}
//# sourceMappingURL=dynamic-pod-control-object.d.ts.map