import * as React from 'react';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
const ConnectedDynamicPodComponent = React.lazy(() => import('./dynamic-pod-component'));
export function AsyncConnectedDynamicPodComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader, bodyHeight: "200px" }) },
        React.createElement(ConnectedDynamicPodComponent, { ...props })));
}
const DynamicPodComponent = React.lazy(() => import('./dynamic-pod-component').then(e => ({ default: e.DynamicPodComponent })));
export function AsyncdynamicPodComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: false, bodyHeight: "200px" }) },
        React.createElement(DynamicPodComponent, { ...props })));
}
//# sourceMappingURL=async-dynamic-pod-component.js.map