import type { IconType } from '@sage/xtrem-shared';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
/**
 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values.
 */
export declare class DropdownListControlObject<ReferencedEnumType extends string = string, CT extends ScreenExtension<CT> = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.DropdownList, FieldComponentProps<FieldKey.DropdownList>> {
    /** The helper text underneath the field */
    helperText?: string;
    /** Indicator, whether sounds play on successful/erroneous selection */
    isSoundDisabled?: boolean;
    /** Placeholder to be displayed in the field body */
    placeholder?: string;
    /** Options to be displayed in the select element */
    options?: string[];
    /** -   **icon**: Icon to be displayed on the right side of the input. The list of icons are defined by [DLS](https://brand.sage.com/d/NdbrveWvNheA/foundations#/icons/icons). */
    icon?: IconType;
    /**
     * The GraphQL node that the select options will be fetched from.
     * When using this property, the node must be an Enum
     */
    get optionType(): string | undefined;
    focus(): void;
    /** Field's value, only valid options can be set as value. */
    set value(newValue: ReferencedEnumType | null);
    /** Field's value, only valid options can be set as value. */
    get value(): ReferencedEnumType | null;
}
//# sourceMappingURL=dropdown-list-control-object.d.ts.map