import * as React from 'react';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
const ConnectedDropdownListComponent = React.lazy(() => import('./dropdown-list-component'));
export function AsyncConnectedDropdownListComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedDropdownListComponent, { ...props })));
}
const DropdownListComponent = React.lazy(() => import('./dropdown-list-component').then(c => ({ default: c.DropdownListComponent })));
export function AsyncDropdownListComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(DropdownListComponent, { ...props })));
}
//# sourceMappingURL=async-dropdown-list-component.js.map