import { showToast } from '../../../service/toast-service';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { mergedValueToSplitValue, splitValueToMergedValue } from '../../../utils/transformers';
import { ReadonlyFieldControlObject } from '../../readonly-field-control-object';
export class DetailListControlObject extends ReadonlyFieldControlObject {
    static { this.defaultUiProperties = {
        ...ReadonlyFieldControlObject.defaultUiProperties,
    }; }
    /** Graphql filter that will restrict the records displayed in the table */
    get filter() {
        return resolveByValue({
            fieldValue: undefined,
            propertyValue: this.getUiComponentProperty('filter'),
            rowValue: undefined,
            screenId: this.screenId,
            skipHexFormat: true,
        });
    }
    /** Graphql filter that will restrict the records displayed in the table */
    set filter(filter) {
        this.setUiComponentProperties('filter', filter);
        this.refresh().catch(() => {
            /* Intentional fire and forget */
        });
    }
    async refresh() {
        await this._refresh({ keepPageInfo: true }).catch(e => {
            showToast(e.message || e, { type: 'warning' });
        });
    }
    /** Detail list items */
    get value() {
        const value = this._getValue();
        if (!value || !value.data) {
            return [];
        }
        return value.data.map(splitValueToMergedValue);
    }
    set value(newValue) {
        if (newValue) {
            const splitValue = newValue.map(mergedValueToSplitValue);
            const previousValue = this._getValue() || { pageInfo: {}, data: [] };
            this._setValue({ ...previousValue, data: [...splitValue] });
        }
        else {
            this._setValue(null);
        }
    }
}
//# sourceMappingURL=detail-list-control-object.js.map