import type { ClientNode } from '@sage/xtrem-client';
import type { GraphQLFilter } from '../../../service/graphql-utils';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import type { DetailListProperties } from '../../control-objects';
import type { DetailListDecoratorProperties } from '../../decorators';
import { ReadonlyFieldControlObject } from '../../readonly-field-control-object';
import type { FieldKey } from '../../types';
export declare class DetailListControlObject<ItemType extends ClientNode = any, CT extends ScreenExtension<CT> = ScreenBase> extends ReadonlyFieldControlObject<CT, FieldKey.DetailList, DetailListProperties<CT, ItemType>> {
    static readonly defaultUiProperties: Partial<DetailListDecoratorProperties>;
    /** Graphql filter that will restrict the records displayed in the table */
    get filter(): GraphQLFilter<ItemType> | undefined;
    /** Graphql filter that will restrict the records displayed in the table */
    set filter(filter: GraphQLFilter<ItemType> | undefined);
    refresh(): Promise<void>;
    /** Detail list items */
    get value(): Partial<ItemType>[];
    set value(newValue: Partial<ItemType>[]);
}
//# sourceMappingURL=detail-list-control-object.d.ts.map