import Button from 'carbon-react/esm/components/button';
import Loader from 'carbon-react/esm/components/loader';
import React from 'react';
import { connect } from 'react-redux';
import { loadCollectionData } from '../../../redux/actions';
import { ConnectedNestedFieldWrapper } from '../../../render/nested-field-wrapper';
import { localize } from '../../../service/i18n-service';
import { getNestedFieldElementId, normalizeUnderscoreBind } from '../../../utils/abstract-fields-utils';
import { getDataTestIdAttribute, getFieldClass, isHidden } from '../../../utils/dom';
import { triggerFieldEvent } from '../../../utils/events';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { splitValueToMergedValue } from '../../../utils/transformers';
import { FieldKey } from '../../types';
import { getFieldTitle } from '../carbon-helpers';
import { mapStateToProps } from '../field-base-component';
import { FieldLabel, HelperText } from '../carbon-utility-components';
import { get } from 'lodash';
import { convertDeepBindToPathNotNull } from '../../../utils/nested-field-utils';
export function DetailListComponent(props) {
    const { browser, elementId, fieldProperties, isLoading, item, loadDetailListData, screenId, value } = props;
    const values = value?.data || [];
    const onClick = () => {
        const queryArguments = {
            after: value?.pageInfo.endCursor,
        };
        if (fieldProperties.filter) {
            queryArguments.filter = JSON.stringify(fieldProperties.filter);
        }
        loadDetailListData(screenId, elementId, fieldProperties.fields, queryArguments, fieldProperties.bind);
    };
    const resolvedTitle = resolveByValue({
        fieldValue: value,
        propertyValue: fieldProperties.title,
        skipHexFormat: true,
        screenId,
        rowValue: null, // This is not a field context, so no row value can be present
    });
    return (React.createElement("div", { className: getFieldClass(screenId, value, 'e-field e-detail-list', fieldProperties, undefined, isHidden(item, browser) ||
            resolveByValue({
                fieldValue: value,
                propertyValue: fieldProperties.isHidden,
                skipHexFormat: true,
                screenId,
                rowValue: null, // This is not a field context, so no row value can be present
            })) },
        resolvedTitle && !fieldProperties.isTitleHidden && React.createElement(FieldLabel, { label: resolvedTitle }),
        renderList({ nestedFields: fieldProperties.fields, values, screenId, elementId, browser }),
        !fieldProperties.isTransient && value?.pageInfo?.hasNextPage && (React.createElement("div", { className: "e-load-more-button-container", "data-testid": "e-load-more-button-container" },
            React.createElement(Button, { buttonType: "tertiary", disabled: isLoading, "data-testid": isLoading ? 'e-is-loading-more-button' : 'e-load-more-button', onClick: onClick }, isLoading ? (React.createElement(Loader, { size: "large" })) : (localize('@sage/xtrem-ui/mobile-table-load-more', 'Load more'))))),
        fieldProperties.helperText && !fieldProperties.isHelperTextHidden && (React.createElement(HelperText, { helperText: props.fieldProperties.helperText }))));
}
const renderList = ({ nestedFields, values, screenId, elementId, browser, }) => {
    return (React.createElement("div", { className: "e-detail-list-container" }, values.map((value, valueIndex) => {
        const mergedRowValue = splitValueToMergedValue(value);
        const onClick = () => {
            triggerFieldEvent(screenId, elementId, 'onRecordClick', mergedRowValue);
        };
        return nestedFields
            .filter(nestedField => {
            const nestedProperties = nestedField.properties;
            const isNestedFieldHidden = resolveByValue({
                screenId,
                fieldValue: get(mergedRowValue, convertDeepBindToPathNotNull(nestedField.properties.bind)),
                propertyValue: nestedProperties.isHidden,
                skipHexFormat: true,
                rowValue: mergedRowValue,
            });
            return (!isNestedFieldHidden &&
                !(nestedProperties.isHiddenDesktop && browser?.greaterThan.s) &&
                !(nestedProperties.isHiddenMobile && !browser?.greaterThan.s));
        })
            .map((nestedField, fieldIndex) => renderItem(nestedField, fieldIndex === 0, value, screenId, elementId, `${valueIndex}-${fieldIndex}`, onClick));
    })));
};
const renderItem = (nestedField, isFirstItem, value, screenId, elementId, key, onRecordClick) => {
    const nestedFieldElementId = getNestedFieldElementId(nestedField);
    const rowValue = splitValueToMergedValue(value);
    const title = getFieldTitle(screenId, nestedField.properties, value);
    return (React.createElement("div", { key: key, onClick: onRecordClick, className: isFirstItem
            ? 'e-detail-list-first-item e-horizontal-separator e-detail-list-item'
            : 'e-detail-list-item', "data-testid": getDataTestIdAttribute('detail-list-item', title, nestedFieldElementId, 'e-detail-list-item') },
        React.createElement("div", { className: "e-detail-list-item-title" }, title && !nestedField.properties.isTitleHidden ? title : ''),
        React.createElement("div", { className: "e-detail-list-item-value" },
            React.createElement(ConnectedNestedFieldWrapper, { _id: nestedFieldElementId, columnDefinition: nestedField, columnName: nestedFieldElementId, columnProperties: getNestedFieldProperties(nestedField), handlersArguments: {
                    rowValue: rowValue ? splitValueToMergedValue(rowValue) : rowValue,
                    onClick: [value._id, splitValueToMergedValue(rowValue)],
                }, screenId: screenId, setFieldValue: () => Promise.resolve(), value: rowValue[normalizeUnderscoreBind(nestedFieldElementId)], parentElementId: elementId, nestedReadOnlyField: true }))));
};
const getNestedFieldProperties = (nestedField) => {
    if (nestedField.type === FieldKey.Link) {
        return nestedField.properties;
    }
    return { ...nestedField.properties, isReadOnly: true };
};
const mapDispatchToProps = (dispatch) => {
    return {
        loadDetailListData: (screenId, elementId, fields, queryArguments, bind) => dispatch(loadCollectionData(screenId, elementId, fields, queryArguments, bind, true)),
    };
};
const customMapStateToProps = (state, props) => {
    const regularProps = mapStateToProps()(state, props);
    return {
        isLoading: state.loading.pages[props.screenId]?.[props.elementId],
        ...regularProps,
    };
};
export const ConnectedDetailListComponent = connect(customMapStateToProps, mapDispatchToProps)(DetailListComponent);
export default ConnectedDetailListComponent;
//# sourceMappingURL=detail-list-component.js.map