import * as React from 'react';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
const ConnectedDetailListComponent = React.lazy(() => import('./detail-list-component'));
export function AsyncConnectedDetailListComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader, bodyHeight: "200px" }) },
        React.createElement(ConnectedDetailListComponent, { ...props })));
}
const DetailListComponent = React.lazy(() => import('./detail-list-component').then(c => ({ default: c.DetailListComponent })));
export function AsyncDetailListComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: true, bodyHeight: "200px" }) },
        React.createElement(DetailListComponent, { ...props })));
}
//# sourceMappingURL=async-detail-list-component.js.map