import { standardDecoratorImplementation, standardExtensionDecoratorImplementation, } from '../../../utils/decorator-utils';
import { AbstractFieldDecorator } from '../../abstract-field-decorator';
import { AbstractFieldLayoutBuilder } from '../../abstract-field-layout-builder';
import { DatetimeControlObject } from './datetime-control-object';
import { FieldKey } from '../../types';
class DatetimeDecorator extends AbstractFieldDecorator {
    constructor() {
        super(...arguments);
        this._layout = AbstractFieldLayoutBuilder;
        this._controlObjectConstructor = DatetimeControlObject;
    }
}
/**
 * Initializes the decorated member as a [dateTime]{@link DateTimeControlObject} field with the provided properties.
 *
 * @param properties The properties that the [dateTime]{@link DateTimeControlObject} field will be initialized with.
 */
export function dateTimeField(properties) {
    return standardDecoratorImplementation(properties, DatetimeDecorator, FieldKey.Datetime, true);
}
export function dateTimeFieldOverride(properties) {
    return standardExtensionDecoratorImplementation(properties);
}
//# sourceMappingURL=datetime-decorator.js.map