/**
 * @packageDocumentation
 * @module root
 */
import type { ClientNode } from '@sage/xtrem-client';
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { DatetimeDecoratorProperties, DatetimeExtensionDecoratorProperties } from './datetime-types';
/**
 * Initializes the decorated member as a [dateTime]{@link DateTimeControlObject} field with the provided properties.
 *
 * @param properties The properties that the [dateTime]{@link DateTimeControlObject} field will be initialized with.
 */
export declare function dateTimeField<T extends ScreenExtension<T>, ReferencedItemType extends ClientNode = any>(properties: DatetimeDecoratorProperties<Extend<T>, ReferencedItemType>): (target: T, name: string) => void;
export declare function dateTimeFieldOverride<T extends ScreenExtension<T>, ReferencedItemType extends ClientNode = any>(properties: DatetimeExtensionDecoratorProperties<T, ReferencedItemType>): (target: T, name: string) => void;
//# sourceMappingURL=datetime-decorator.d.ts.map