/**
 * @packageDocumentation
 * @module root
 */
import type { ClientNode } from '@sage/xtrem-client';
import type { Datetime } from '@sage/xtrem-date-time';
import type { ScreenBase } from '../../../service/screen-base';
import { EditableFieldControlObject } from '../../editable-field-control-object';
import type { FieldComponentProps, FieldKey } from '../../types';
import type { DatetimeValue } from './datetime-types';
type AllowableDate = Datetime | Date | string;
export declare class DatetimeControlObject<ReferencedItemType extends ClientNode = any, CT extends ScreenBase = ScreenBase> extends EditableFieldControlObject<CT, FieldKey.Datetime, FieldComponentProps<FieldKey.Datetime>> {
    isTimeZoneHidden?: boolean;
    timeZone?: string;
    minDate?: AllowableDate;
    maxDate?: AllowableDate;
    defaultDate?: AllowableDate;
    /** Moves the browser focus to this field */
    focus(): void;
    get value(): DatetimeValue | null;
    set value(value: DatetimeValue | null);
}
export {};
//# sourceMappingURL=datetime-control-object.d.ts.map