import React from 'react';
import { formatDatetime } from '../../ui/datetime/datetime-utils';
export const DatetimeCellRenderer = React.memo(props => {
    const fieldProperties = React.useMemo(() => props.fieldProperties, [props.fieldProperties]);
    const value = React.useMemo(() => formatDatetime({ date: props.value }), [props.value]);
    const dataTestId = React.useMemo(() => `${props.tableElementId}-${props.node.rowIndex}-${props.api.getColumns().indexOf(props.column) + 1}`, [props.api, props.column, props.node.rowIndex, props.tableElementId]);
    return (React.createElement(fieldProperties.wrapper, { ...props }, value === '' ? null : (React.createElement("div", { "data-testid": dataTestId, className: "e-datetime-cell-renderer" },
        React.createElement("span", { "data-testid": `${dataTestId}`, className: "e-datetime-cell-renderer-start" }, value)))));
});
DatetimeCellRenderer.displayName = 'DatetimeCellRenderer';
//# sourceMappingURL=datetime-cell-renderer.js.map