import * as React from 'react';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
const ConnectedDatetimeComponent = React.lazy(() => import('./datetime-component'));
export function AsyncConnectedDatetimeComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedDatetimeComponent, { ...props })));
}
const DatetimeComponent = React.lazy(() => import('./datetime-component').then(c => ({ default: c.DatetimeComponent })));
export function AsyncDatetimeComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(DatetimeComponent, { ...props })));
}
//# sourceMappingURL=async-datetime-component.js.map