import type { CalendarDate } from '@internationalized/date';
import type { LocalizeLocale } from '@sage/xtrem-shared';
import type { DatetimeRangeProperties, DatetimeRangeValue, NestedDatetimeRangeProperties } from './datetime-range-types';
export interface DatetimeRangeComponentState {
    value: DatetimeRangeValue;
    endDate: CalendarDate | null;
    validationError: boolean;
    endTime: string | null;
    startDate: CalendarDate | null;
    startTime: string | null;
    timeZone: string;
    openInputPopover: 'start' | 'end' | null;
}
export type Action = {
    type: 'SET_START_DATE';
    date: DatetimeRangeComponentState['startDate'];
} | {
    type: 'SET_END_DATE';
    date: DatetimeRangeComponentState['endDate'];
} | {
    type: 'SET_START_TIME';
    time: DatetimeRangeComponentState['startTime'];
} | {
    type: 'SET_END_TIME';
    time: DatetimeRangeComponentState['endTime'];
} | {
    type: 'SET_OPEN_POPOVER_ON_INPUT';
    inputName: 'start' | 'end';
    isOpen: boolean;
} | {
    type: 'RESET';
    value?: DatetimeRangeValue | null;
    timeZone: string;
};
export interface UseDatetimeRangeProps {
    value?: DatetimeRangeValue | null;
    fieldProperties: DatetimeRangeProperties | NestedDatetimeRangeProperties;
    locale: LocalizeLocale;
    setFieldValue: any;
    validate: any;
    elementId: string;
    screenId: string;
    onChange: (value: DatetimeRangeValue | null) => void;
    minDate?: CalendarDate;
    maxDate?: CalendarDate;
}
export interface UseDatetimeRangeResult {
    currentDates: DatetimeRangeValue;
    endDate: CalendarDate | null;
    validationError: boolean;
    endTime: string | null;
    handleEndDateChange: (date: CalendarDate) => void;
    handleEndTimeChange: (time: string) => void;
    handlePopoverOpenChange: (isOpen: boolean, inputName: 'start' | 'end') => void;
    handleStartDateChange: (date: CalendarDate) => void;
    handleStartTimeChange: (time: string) => void;
    openInputPopover: 'start' | 'end' | null;
    startDate: CalendarDate | null;
    startTime: string | null;
    timeZone: string;
    initialDate?: CalendarDate;
}
export declare function useDatetimeRange({ fieldProperties, value, onChange }: UseDatetimeRangeProps): UseDatetimeRangeResult;
//# sourceMappingURL=use-datetime-range.d.ts.map