import type { ClientNode } from '@sage/xtrem-client';
import type { Datetime } from '@sage/xtrem-date-time';
import type { FieldKey } from '@sage/xtrem-shared';
import type { Extend } from '../../../service/page-extension';
import type { ScreenBase } from '../../../service/screen-base';
import type { ScreenExtension } from '../../../types';
import type { ChangeableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { DatePropertyValue, ValueOrCallback } from '../../../utils/types';
import type { BlockControlObject } from '../../control-objects';
import type { EditableFieldProperties } from '../../editable-field-control-object';
import type { NestedField, NestedFieldHandlersArguments, NestedPropertiesWrapper } from '../../nested-fields';
import type { FieldControlObjectInstance } from '../../types';
import type { BaseEditableComponentProperties } from '../field-base-component-types';
import type { Changeable, Clickable, ExtensionField, HasParent, Nested, NestedChangeable, NestedValidatable, Sizable, Validatable } from '../traits';
export interface DatetimeRangeProperties<CT extends ScreenExtension<CT> = ScreenBase, NodeType = any> extends EditableFieldProperties<CT, NodeType>, Sizable {
    isTimeZoneHidden?: boolean;
    timeZone?: string;
    minDate?: ValueOrCallback<CT, DatePropertyValue>;
    maxDate?: ValueOrCallback<CT, DatePropertyValue>;
    defaultDate?: Date | Datetime | string;
}
export interface DatetimeRangeDecoratorProperties<CT extends ScreenBase = ScreenBase, ReferencedItemType extends ClientNode = any> extends Omit<DatetimeRangeProperties<CT, ReferencedItemType>, '_controlObjectType'>, Changeable<CT>, Clickable<CT>, ExtensionField<CT, FieldControlObjectInstance<any>>, HasParent<CT, BlockControlObject<CT>>, Sizable, Validatable<CT, string> {
}
export interface NestedDatetimeRangeProperties<CT extends ScreenBase = ScreenBase, ContextNodeType extends ClientNode = any> extends NestedPropertiesWrapper<DatetimeRangeProperties<CT, ContextNodeType>>, NestedChangeable<CT>, Nested<ContextNodeType>, Sizable, NestedValidatable<CT, string, ContextNodeType> {
}
export type DatetimeRangeExtensionDecoratorProperties<CT extends ScreenExtension<CT>, ReferencedItemType extends ClientNode = any> = ChangeableOverrideDecoratorProperties<DatetimeRangeDecoratorProperties<Extend<CT>, ReferencedItemType>, CT>;
export interface DatetimeRangeValue {
    start: Datetime | null;
    end: Datetime | null;
}
export interface DatetimeRangeComponentProps<T extends ClientNode = any> extends BaseEditableComponentProperties<DatetimeRangeDecoratorProperties<any, T>, DatetimeRangeValue> {
    columnDefinition?: NestedField<ScreenBase, FieldKey.DatetimeRange>;
    isNested?: boolean;
    parentElementId?: string;
    handlersArguments?: NestedFieldHandlersArguments;
}
//# sourceMappingURL=datetime-range-types.d.ts.map