import React from 'react';
import { formatDatetime } from '../../ui/datetime/datetime-utils';
export const DatetimeRangeCellRenderer = React.memo(props => {
    const fieldProperties = React.useMemo(() => props.fieldProperties, [props.fieldProperties]);
    const value = React.useMemo(() => props.value, [props.value]);
    const start = React.useMemo(() => value?.start
        ? formatDatetime({ date: value?.start, locale: props.locale, separator: ' ' })
        : '', [props.locale, value?.start]);
    const end = React.useMemo(() => value?.end
        ? formatDatetime({ date: value?.end, locale: props.locale, separator: ' ' })
        : '', [props.locale, value?.end]);
    const dataTestId = React.useMemo(() => `${props.tableElementId}-${props.node.rowIndex}-${props.api.getColumns().indexOf(props.column) + 1}`, [props.api, props.column, props.node.rowIndex, props.tableElementId]);
    return (React.createElement(fieldProperties.wrapper, { ...props }, start === '' && end === '' ? null : (React.createElement("div", { "data-testid": dataTestId, className: "e-datetime-cell-renderer" },
        React.createElement("span", { "data-testid": `${dataTestId}-start`, className: "e-datetime-cell-renderer-start" }, start),
        React.createElement("span", null, "-"),
        React.createElement("span", { "data-testid": `${dataTestId}-end`, className: "e-datetime-cell-renderer-end" }, end)))));
});
DatetimeRangeCellRenderer.displayName = 'DatetimeRangeCellRenderer';
//# sourceMappingURL=datetime-range-cell-renderer.js.map