import React from 'react';
import type { CellParams } from '../../../utils/ag-grid/ag-grid-column-config';
import type { NestedDateProperties } from './date-types';
type EventTargetOnDateChange = {
    value: {
        formattedValue: string;
        rawValue: string;
    };
};
interface DateEditorState {
    value: string;
    highlightOnFocus: boolean;
}
export default class DateCellEditor extends React.Component<CellParams<NestedDateProperties>, DateEditorState> {
    constructor(props: CellParams<NestedDateProperties>);
    componentDidMount(): void;
    handleChange(event: React.ChangeEvent<EventTargetOnDateChange>): void;
    onKeyDown(event: React.KeyboardEvent): void;
    getCarbonProps: () => any;
    render(): React.ReactNode;
}
export {};
//# sourceMappingURL=date-cell-editor.d.ts.map