/**
 * @packageDocumentation
 * @module root
 * */
import type { ClientNode } from '@sage/xtrem-client';
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ClickableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { CountDecoratorProperties } from './count-types';
/**
 * Initializes the decorated member as a [Count]{@link CountControlObject} field with the provided properties
 *
 * @param properties The properties that the [Count]{@link CountControlObject} field will be initialized with
 */
export declare function countField<T extends ScreenExtension<T>, ReferencedItemType extends ClientNode = any>(properties: CountDecoratorProperties<Extend<T>, ReferencedItemType>): (target: T, name: string) => void;
export declare function countFieldOverride<T extends ScreenExtension<T>, ReferencedItemType extends ClientNode = any>(properties: ClickableOverrideDecoratorProperties<CountDecoratorProperties<Extend<T>, ReferencedItemType>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=count-decorator.d.ts.map