import * as React from 'react';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
const ConnectedCountComponent = React.lazy(() => import('./count-component'));
export function AsyncConnectedCountComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedCountComponent, { ...props })));
}
const CountComponent = React.lazy(() => import('./count-component').then(c => ({ default: c.CountComponent })));
export function AsyncCountComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(CountComponent, { ...props })));
}
//# sourceMappingURL=async-count-component.js.map