import * as React from 'react';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
const ConnectedContentTableComponent = React.lazy(() => import('./content-table-component'));
export function AsyncConnectedContentTableComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader, bodyHeight: "80px" }) },
        React.createElement(ConnectedContentTableComponent, { ...props })));
}
const ContentTableComponent = React.lazy(() => import('./content-table-component').then(c => ({ default: c.ContentTableComponent })));
export function AsyncContentTableComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField, bodyHeight: "80px" }) },
        React.createElement(ContentTableComponent, { ...props })));
}
//# sourceMappingURL=async-content-table-component.js.map