import type { ClientNode } from '@sage/xtrem-client';
import { CollectionValue } from '../../service/collection-data-service';
import type { AggregationMethod } from '../../service/collection-data-types';
import type { GraphQLFilter } from '../../service/graphql-utils';
import type { ScreenBase } from '../../service/screen-base';
import type { ValidationResult } from '../../service/screen-base-definition';
import type { NestedRecordId, ScreenBaseGenericType, ScreenExtension } from '../../types';
import type { ValueOrCallbackWithFieldValue } from '../../utils/types';
import type { NestedFieldTypes } from '../nested-fields';
import type { ReadonlyFieldProperties } from '../readonly-field-control-object';
import { ReadonlyFieldControlObject } from '../readonly-field-control-object';
import type { CollectionValueFieldKey, FieldControlObjectConstructorProps, OrderByType, PartialCollectionValue, PartialCollectionValueWithIds } from '../types';
import type { HasFilter, HasServerRecordMapperFunction } from './traits';
export interface CollectionValueFieldProperties<CT extends ScreenExtension<CT> = ScreenBase, NestedRecordType extends ClientNode = any> extends HasFilter<CT, NestedRecordType>, HasServerRecordMapperFunction<CT, NestedRecordType>, ReadonlyFieldProperties<CT> {
    /** Selected records identifiers */
    selectedRecords?: NestedRecordId[];
    /** The GraphQL node that the table represents, needed for filtering */
    node?: keyof ScreenBaseGenericType<CT>;
    /** The column or the set of columns which the table should be sorted by */
    orderBy?: OrderByType<NestedRecordType>;
    /** Number of lines displayed by default in the table, if not defined it defaults to 20 */
    pageSize?: number;
    /** Whether the records of the table can be selected or not. Defaults to true */
    canSelect?: boolean;
    /** Indicate additional warning message, rendered as tooltip and blue border. */
    infoMessage?: ValueOrCallbackWithFieldValue<CT, string, any, NestedRecordType>;
    /** Indicate additional information, rendered as tooltip and orange border. */
    warningMessage?: ValueOrCallbackWithFieldValue<CT, string, any, NestedRecordType>;
}
export declare abstract class CollectionValueControlObject<FT extends CollectionValueFieldKey, NestedRecordType extends ClientNode = any, CT extends ScreenExtension<CT> = ScreenBase, AvailableNestedFieldTypes extends NestedFieldTypes = NestedFieldTypes, FieldProps extends CollectionValueFieldProperties<CT, NestedRecordType> = CollectionValueFieldProperties<CT, NestedRecordType>> extends ReadonlyFieldControlObject<CT, CollectionValueFieldKey, FieldProps, NestedRecordType> {
    protected readonly _isFieldDirty: (screenId: string, elementId: string) => boolean;
    protected _setFieldDirty: (screenId: string, elementId: string) => void;
    protected _setFieldClean: (screenId: string, elementId: string) => void;
    constructor(properties: FieldControlObjectConstructorProps<FT>);
    private readonly createCollectionValue;
    ensureFieldHasValue(): CollectionValue<NestedRecordType>;
    /** Graphql filter that will restrict the records displayed in the table */
    get filter(): GraphQLFilter<NestedRecordType> | undefined;
    /** Graphql filter that will restrict the records displayed in the table */
    set filter(filter: GraphQLFilter<NestedRecordType> | undefined);
    /** Number of lines displayed by default in the table, if not defined it defaults to 20 */
    pageSize?: number;
    /** Whether the records of this table can be selected or not */
    canSelect?: boolean;
    get isDirty(): boolean;
    set isDirty(newValue: boolean);
    /**
     * Indicate additional warning message, rendered as tooltip and blue border.
     */
    get infoMessage(): string | undefined;
    /**
     * Indicate additional warning message, rendered as tooltip and blue border.
     */
    set infoMessage(infoMessage: string | undefined);
    /**
     * Indicate additional information, rendered as tooltip and orange border
     */
    get warningMessage(): string | undefined;
    /**
     * Indicate additional information, rendered as tooltip and orange border
     */
    set warningMessage(warningMessage: string | undefined);
    /**
     * Return all table records known to the client, it does not include records which were not previously fetched by some
     * user interaction such as pagination
     * */
    get value(): PartialCollectionValueWithIds<NestedRecordType>[];
    /**
     * Resets the value of the table, all pending changes are be overridden and all cached records are discarded
     * */
    set value(newValue: PartialCollectionValueWithIds<NestedRecordType>[]);
    revalidate(fn: (record: PartialCollectionValueWithIds<NestedRecordType>) => boolean): Promise<void>;
    /** Update the value of a single record in the collection */
    setRecordValue(recordData: PartialCollectionValueWithIds<NestedRecordType>): void;
    /** Return a single record that is already known to the client */
    getRecordValue(recordId: string): PartialCollectionValueWithIds<NestedRecordType> | null;
    /** Return a single record that is already known to the client along with all its internal properties */
    getInternalRowValue(recordId: string): PartialCollectionValueWithIds<NestedRecordType> | null;
    /** Add a single record in the table and in its dataset */
    addRecord(recordData: PartialCollectionValue<NestedRecordType>): PartialCollectionValueWithIds<NestedRecordType>;
    /** Add a single record in the table and in its dataset with default values coming from the server */
    addRecordWithDefaults(recordData?: PartialCollectionValue<NestedRecordType>): Promise<PartialCollectionValueWithIds<NestedRecordType>>;
    /** Add or update record in the table depending of the existence of the ID field */
    addOrUpdateRecordValue(recordData: PartialCollectionValue<NestedRecordType>): PartialCollectionValueWithIds<NestedRecordType>;
    /** Remove a single record from the table and its dataset */
    removeRecord(recordId: NestedRecordId): void;
    /** Gets a record by a given field and value */
    getRecordByFieldValue(fieldName: keyof NestedRecordType, fieldValue: any): PartialCollectionValue<NestedRecordType> | null;
    /** Selected records identifiers */
    get selectedRecords(): NestedRecordId[];
    /** Selected records identifiers */
    set selectedRecords(recordIds: NestedRecordId[]);
    /** Adds the record identifier to the set of selected items */
    selectRecord(recordId: NestedRecordId): void;
    /** Removes the record identifier from the set of selected items */
    unselectRecord(recordId: NestedRecordId): void;
    /** Unselects all items in the collection */
    unselectAllRecords(): void;
    /** Returns an auto-generated ID that can be used for a new record */
    generateRecordId(): string;
    refresh(keepModifications?: boolean): Promise<void>;
    /**
     * Triggers the field validation rules. Since the validation rules might be asynchronous,
     * this method returns a promise that must be awaited to get the validation result
     */
    validate(forceValidate?: boolean): Promise<string[]>;
    /**
     * Triggers the field validation rules. Since the validation rules might be asynchronous,
     * this method returns a promise that must be awaited to get the validation result. Compared to the `validate` method
     * it returns more details, including the rule that failed and where applicable, the row ID and colum ID.
     */
    validateWithDetails(forceValidate?: boolean): Promise<ValidationResult[]>;
    refreshRecord(recordId: string, skipUpdate?: boolean): Promise<PartialCollectionValueWithIds<NestedRecordType>>;
    /**
     * Calculate aggregated values ('min' | 'max' | 'sum' | 'avg' | 'count').
     * Returns Number.NaN if not all records have been fetched from the server.
     */
    calculateAggregatedValue({ aggregationKey, aggregationMethod, level, parentId, }: {
        aggregationMethod: AggregationMethod;
        aggregationKey: string;
        level?: number | null;
        parentId?: string | null;
    }): number;
}
//# sourceMappingURL=collection-value-field.d.ts.map