/**
 * @packageDocumentation
 * @module root
 * */
import type { Extend } from '../../../service/page-extension';
import type { ScreenExtension } from '../../../types';
import type { ChangeableOverrideDecoratorProperties } from '../../../utils/decorator-utils';
import type { CheckboxDecoratorProperties } from './checkbox-types';
/**
 * Initializes the decorated member as a [Checkbox]{@link CheckboxControlObject} field with the provided properties
 *
 * @param properties The properties that the [Checkbox]{@link CheckboxControlObject} field will be initialized with
 */
export declare function checkboxField<T extends ScreenExtension<T>>(properties: CheckboxDecoratorProperties<Extend<T>>): (target: T, name: string) => void;
export declare function checkboxFieldOverride<T extends ScreenExtension<T>>(properties: ChangeableOverrideDecoratorProperties<CheckboxDecoratorProperties<Extend<T>>, Extend<T>>): (target: T, name: string) => void;
//# sourceMappingURL=checkbox-decorator.d.ts.map