import { Checkbox } from 'carbon-react/esm/components/checkbox';
import * as React from 'react';
import { connect } from 'react-redux';
import { Icon } from '../../ui/icon/icon-component';
import { getCommonCarbonComponentProperties } from '../carbon-helpers';
import { FieldLabel, HelperText } from '../carbon-utility-components';
import { EditableFieldBaseComponent, mapDispatchToProps, mapStateToProps } from '../field-base-component';
import { handleChange } from '../../../utils/abstract-fields-utils';
export class CheckboxComponent extends EditableFieldBaseComponent {
    constructor() {
        super(...arguments);
        this.onChange = (event) => {
            const displayValue = event.target.checked;
            const value = this.props.fieldProperties.isValueReversed ? !displayValue : displayValue;
            if (this.props.value !== value) {
                handleChange(this.props.elementId, value, this.props.setFieldValue, this.props.validate, this.triggerChangeListener);
            }
        };
    }
    render() {
        const value = !!this.props.value || false;
        const displayValue = this.props.fieldProperties.isValueReversed ? !value : value;
        const iconValue = value ? 'tick' : 'cross';
        const noPadding = this.props.fieldProperties.noPadding ? ' e-no-padding' : '';
        return (React.createElement("div", { ref: this.componentRef, ...this.getBaseAttributesDivWrapper('checkbox', `e-checkbox-field${noPadding}`, this.props.contextType, this.props.handlersArguments?.rowValue, this.props.isNested), onClick: !this.isReadOnly() ? undefined : this.getClickHandler() }, this.isReadOnly() ? (React.createElement("div", { className: "e-checkbox-field-read-only common-input" },
            React.createElement(Icon, { type: iconValue }),
            React.createElement("div", null,
                (this.props.shouldRenderLabelInNestedReadOnlyMode || !this.props.isNested) && (React.createElement(FieldLabel, { label: this.getTitle() })),
                React.createElement(HelperText, { helperText: this.props.fieldProperties.helperText })))) : (React.createElement(Checkbox, { checked: displayValue, value: "checked", onClick: this.getClickHandler(), onChange: this.onChange, reverse: this.props.fieldProperties.isReversed, ...getCommonCarbonComponentProperties(this.props) }))));
    }
}
export const ConnectedCheckboxComponent = connect(mapStateToProps(), mapDispatchToProps())(CheckboxComponent);
export default ConnectedCheckboxComponent;
//# sourceMappingURL=checkbox-component.js.map