import * as React from 'react';
import { InputFieldSkeleton } from '../../ui/input-field-skeleton';
import { hasConnectedSkeletonFieldTitle } from '../../../utils/async-component-utils';
const ConnectedCheckboxComponent = React.lazy(() => import('./checkbox-component'));
export function AsyncConnectedCheckboxComponent(props) {
    const hasHeader = hasConnectedSkeletonFieldTitle(props);
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: hasHeader }) },
        React.createElement(ConnectedCheckboxComponent, { ...props })));
}
const CheckboxComponent = React.lazy(() => import('./checkbox-component').then(c => ({ default: c.CheckboxComponent })));
export function AsyncCheckboxComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(InputFieldSkeleton, { hasTitle: !props.nestedReadOnlyField }) },
        React.createElement(CheckboxComponent, { ...props })));
}
//# sourceMappingURL=async-checkbox-component.js.map