import React from 'react';
import { PieChart, Pie, Cell, Tooltip, Legend, ResponsiveContainer } from 'recharts';
import { get, isNil } from 'lodash';
import { formatChartLabel } from '../chart-utils';
export function PieChartComponent({ pie, locale, data, xAxis, height, screenId, legend, isLegendHidden, labelNestedField, }) {
    if (!pie) {
        throw new Error('No pie chart options provided.');
    }
    const getLabel = React.useCallback((p) => {
        const rowValue = p.payload?.payload;
        const label = get(rowValue, p.name, null);
        return isNil(label)
            ? formatChartLabel({ value: p.value, nestedField: pie.valueNestedField, locale, rowValue, screenId })
            : formatChartLabel({ value: label, nestedField: labelNestedField, locale, rowValue, screenId });
    }, [locale, labelNestedField, pie.valueNestedField, screenId]);
    const getLegendLabel = React.useCallback((_, entry) => {
        const bind = entry.payload.name;
        const rowValue = entry.payload.payload;
        const value = get(rowValue, bind, null);
        return formatChartLabel({ value, nestedField: labelNestedField, locale, rowValue, screenId });
    }, [labelNestedField, locale, screenId]);
    const fills = pie.fills;
    return (React.createElement(ResponsiveContainer, { width: "100%", height: height },
        React.createElement(PieChart, null,
            React.createElement(Pie, { data: data, dataKey: pie.angleKey, name: pie.labelKey, nameKey: xAxis.key, stroke: pie.stroke, label: isLegendHidden ? getLabel : undefined }, data.map((entry, index) => (
            // eslint-disable-next-line react/no-array-index-key
            React.createElement(Cell, { key: `cell-${index}`, fill: fills[index % fills.length] })))),
            React.createElement(Tooltip, null),
            legend.enabled && (React.createElement(Legend, { verticalAlign: legend.position, formatter: getLegendLabel })))));
}
//# sourceMappingURL=pie-chart-component.js.map