import * as tokens from '@sage/design-tokens/js/base/common';
import { formatDateToCurrentLocale } from '@sage/xtrem-date-time';
import { FieldKey, objectKeys } from '@sage/xtrem-shared';
import { formatNumericValue } from '../../../utils/formatters';
import { ChartTypes } from '../../chart-types';
export const chartColors = [
    tokens.colorsActionMajor500,
    tokens.colorsSemanticCaution500,
    tokens.colorsSemanticPositive500,
    tokens.colorsSemanticNegative500,
    tokens.colorsSemanticInfo500,
    tokens.colorsUtilityMajor200,
    tokens.colorsUtilityMajor100,
];
export function getChartOptions({ screenId, properties, locale, collection, }) {
    const isPieChart = properties.chart.type === ChartTypes.Pie;
    let series;
    let pie;
    if (isPieChart) {
        pie = {
            labelKey: properties.chart.xAxis.properties.bind,
            angleKey: properties.chart.series[0].properties.bind,
            stroke: chartColors[0],
            fills: chartColors,
            valueNestedField: properties.chart.series[0],
        };
    }
    else {
        // Other chart types (line, bar)
        series = properties.chart.series.map((currentSeries, index) => {
            const currentSeriesProperties = currentSeries.properties;
            const color = chartColors.length < index + 1 ? chartColors[0] : chartColors[index];
            return {
                stroke: color,
                xKey: properties.chart.xAxis.properties.bind,
                yKey: currentSeriesProperties.bind,
                yName: currentSeriesProperties.title,
                seriesNestedField: currentSeries,
            };
        });
    }
    const yAxesProperties = isPieChart ? [pie?.angleKey] : series?.map(s => s.yKey);
    // Remapping Y Axes values to ensure that they are numbers
    const data = collection?.data?.map(d => objectKeys(d).reduce((prevValue, currentValue) => {
        if (yAxesProperties.indexOf(currentValue) !== -1) {
            prevValue[currentValue] = Number(d[currentValue]);
        }
        else {
            prevValue[currentValue] = d[currentValue];
        }
        return prevValue;
    }, {})) || [];
    const chartOptions = {
        type: properties.chart.type,
        locale,
        screenId,
        data,
        pie,
        height: 300,
        series,
        labelNestedField: properties.chart.xAxis,
        isLegendHidden: !!properties.isLegendHidden,
        legend: {
            enabled: !properties.isLegendHidden,
            position: 'bottom',
        },
        xAxis: {
            key: properties.chart.xAxis.properties.bind,
        },
    };
    return chartOptions;
}
export function formatChartLabel({ screenId, nestedField, locale, value, rowValue, }) {
    switch (nestedField.type) {
        case FieldKey.Date:
            return formatDateToCurrentLocale(value, locale);
        case FieldKey.Numeric:
            return formatNumericValue({
                screenId,
                value,
                locale,
                rowValue,
                scale: nestedField.properties.scale,
            });
        default:
            return value;
    }
}
//# sourceMappingURL=chart-utils.js.map