/**
 * @packageDocumentation
 * @module root
 * */
var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { showToast } from '../../../service/toast-service';
import { resolveByValue } from '../../../utils/resolve-value-utils';
import { ControlObjectProperty } from '../../property-decorators/control-object-property-decorator';
import { ReadonlyFieldControlObject } from '../../readonly-field-control-object';
/**
 * [Field]{@link ReadonlyFieldControlObject} that holds a set of read-only values and represents them as a chart
 */
export class ChartControlObject extends ReadonlyFieldControlObject {
    static { this.defaultUiProperties = {
        ...ReadonlyFieldControlObject.defaultUiProperties,
        canFilter: true,
    }; }
    /** Graphql filter that will restrict the records displayed in the chart */
    get filter() {
        return resolveByValue({
            fieldValue: undefined,
            propertyValue: this.getUiComponentProperty('filter'),
            rowValue: undefined,
            screenId: this.screenId,
            skipHexFormat: true,
        });
    }
    /** Graphql filter that will restrict the records displayed in the chart */
    set filter(filter) {
        this.setUiComponentProperties('filter', filter);
        this.refresh().catch(() => {
            /* Intentional fire and forget */
        });
    }
    /** Chart values */
    get value() {
        const value = this._getValue();
        return value && value.data ? value.data : [];
    }
    /** Chart values */
    set value(newValue) {
        const previousValue = this._getValue() || { data: [], pageInfo: {} };
        this._setValue({ ...previousValue, data: newValue });
    }
    async refresh() {
        await this._refresh({ keepPageInfo: true }).catch(e => {
            showToast(e.message || e, { type: 'warning' });
        });
    }
}
__decorate([
    ControlObjectProperty()
    /** Whether the legend should be hidden */
], ChartControlObject.prototype, "isLegendHidden", void 0);
//# sourceMappingURL=chart-control-object.js.map