import * as React from 'react';
import type { Filter } from '../../../service/filter-service';
import type { GraphqlCollection } from '../../types';
import type { FilterManagerField } from '../../ui/filter/filter-manager';
import { ReadonlyFieldBaseComponent } from '../field-base-component';
import type { ChartComponentProps, ChartComponentState, ChartDecoratorProperties } from './chart-types';
import type { OptionalNodePropertyType } from '../../../types';
export declare class ChartComponent extends ReadonlyFieldBaseComponent<ChartDecoratorProperties, GraphqlCollection, ChartComponentProps, ChartComponentState> {
    constructor(props: ChartComponentProps);
    onFilterChange: () => Promise<void>;
    renderChart(): React.ReactNode;
    saveFilters: (filters: Filter[]) => void;
    getFilterableFields: (node: OptionalNodePropertyType, nestedFields: ChartDecoratorProperties["chart"]["series"]) => FilterManagerField[];
    getNestedFields: () => FilterManagerField[];
    render(): React.ReactNode;
}
export declare const ConnectedChartComponent: import("react-redux").ConnectedComponent<typeof ChartComponent, {
    key?: React.Key | null | undefined;
    ref?: React.LegacyRef<ChartComponent> | undefined;
    parentElementId?: string | undefined;
    level?: number | undefined;
    contextNode?: import("../../../types").NodePropertyType | undefined;
    recordContext?: any;
    columnDefinition?: any;
    handlersArguments?: import("../../nested-fields").NestedFieldHandlersArguments | undefined;
    isNested?: boolean | undefined;
    bind?: import("../reference/reference-types").PropertyValueType<import("@sage/xtrem-client").ClientNode | any>;
    elementId: string;
    isParentDisabled?: boolean | undefined;
    isParentHidden?: boolean | undefined;
    item?: import("../../..").PageArticleItem | undefined;
    screenId: string;
    contextType?: import("../../../types").ContextType | undefined;
    nestedReadOnlyField?: boolean | undefined;
    shouldRenderLabelInNestedReadOnlyMode?: boolean | undefined;
    availableColumns?: number | undefined;
    isUsingInfiniteScroll?: boolean | undefined;
    context?: React.Context<import("react-redux").ReactReduxContextValue<any, UnknownAction> | null> | undefined;
    store?: import("redux").Store | undefined;
}>;
export default ConnectedChartComponent;
//# sourceMappingURL=chart-component.d.ts.map