import React from 'react';
import { BarChart, Bar, XAxis, YAxis, CartesianGrid, Tooltip, Legend, ResponsiveContainer } from 'recharts';
export function BarChartComponent(props) {
    if (!props.series) {
        throw new Error('No bar chart options provided.');
    }
    const Bars = props.series.map(serie => (React.createElement(Bar, { dataKey: serie.yKey, name: serie.yName, fill: serie.stroke, key: serie.yKey })));
    return (React.createElement(ResponsiveContainer, { width: "100%", height: props.height },
        React.createElement(BarChart, { data: props.data },
            React.createElement(CartesianGrid, { strokeDasharray: "3 3" }),
            React.createElement(XAxis, { dataKey: props.xAxis.key }),
            React.createElement(YAxis, null),
            React.createElement(Tooltip, null),
            props.legend.enabled && React.createElement(Legend, { verticalAlign: props.legend.position }),
            Bars)));
}
//# sourceMappingURL=bar-chart-component.js.map