var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
import { showToast } from '../../../service/toast-service';
import { ControlObjectProperty } from '../../property-decorators/control-object-property-decorator';
import { ReadonlyFieldControlObject } from '../../readonly-field-control-object';
/**
 * [Field]{@link EditableFieldControlObject} that holds a value from a set of given values.
 */
export class CardControlObject extends ReadonlyFieldControlObject {
    static { this.defaultUiProperties = {
        ...ReadonlyFieldControlObject.defaultUiProperties,
    }; }
    /** The GraphQL node that the field suggestions will be fetched from */
    get node() {
        return String(this.getUiComponentProperty('node'));
    }
    async refresh() {
        await this._refresh({ keepPageInfo: true }).catch(e => {
            showToast(e.message || e, { type: 'warning' });
        });
    }
    focus() {
        this._focus();
    }
}
__decorate([
    ControlObjectProperty()
    /** The helper text underneath the field */
], CardControlObject.prototype, "helperText", void 0);
//# sourceMappingURL=card-control-object.js.map