import * as React from 'react';
import { connect } from 'react-redux';
import { ReadonlyFieldBaseComponent, mapDispatchToProps, mapStateToProps } from '../field-base-component';
import { getComponentClass, getDataTestIdAttribute } from '../../../utils/dom';
import { CardComponent as Card } from '../../ui/card/card-component';
import { FieldLabel, HelperText } from '../carbon-utility-components';
import { getImagePlaceholderValue } from '../../../utils/nested-field-utils';
import { FieldKey } from '../../types';
import * as tokens from '@sage/design-tokens/js/base/common';
export class CardComponent extends ReadonlyFieldBaseComponent {
    render() {
        const title = this.getTitle();
        const isDisabled = this.getResolvedProperty('isDisabled');
        const { isTitleHidden, helperText, onClick } = this.props.fieldProperties;
        const cardDefinition = { ...this.props.fieldProperties.cardDefinition };
        if (cardDefinition.image &&
            cardDefinition.image.type === FieldKey.Image &&
            !cardDefinition.image.properties.placeholderValue) {
            cardDefinition.image.properties = {
                ...cardDefinition.image.properties,
                placeholderValue: () => getImagePlaceholderValue(this.props.value, cardDefinition.title),
            };
        }
        if (cardDefinition.image && cardDefinition.image.type === FieldKey.Icon) {
            cardDefinition.image.properties = {
                ...cardDefinition.image.properties,
                color: tokens.colorsUtilityMajor300,
                backgroundColor: tokens.colorsActionMinor050,
                backgroundShape: 'circle',
                backgroundSize: 'large',
            };
        }
        const cardProps = {
            cardDefinition,
            screenId: this.props.screenId,
            parentElementId: this.props.elementId,
            value: this.props.value,
            onCardClick: onClick && !isDisabled ? this.getClickHandler() : undefined,
            isClickIndicatorHidden: true,
        };
        return (React.createElement("div", { "data-testid": getDataTestIdAttribute('card', title, this.props.elementId), className: getComponentClass(this.props, 'e-card-field') },
            !isTitleHidden && title && React.createElement(FieldLabel, { label: title }),
            this.props.value && React.createElement(Card, { ...cardProps }),
            React.createElement(HelperText, { helperText: helperText })));
    }
}
export const ConnectedCardComponent = connect(mapStateToProps(), mapDispatchToProps())(CardComponent);
export default ConnectedCardComponent;
//# sourceMappingURL=card-component.js.map