import * as React from 'react';
import Loader from 'carbon-react/esm/components/loader';
const ConnectedCardComponent = React.lazy(() => import('./card-component'));
export function AsyncConnectedCardComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(Loader, null) },
        React.createElement(ConnectedCardComponent, { ...props })));
}
const CardComponent = React.lazy(() => import('./card-component').then(c => ({ default: c.CardComponent })));
export function AsyncCardComponent(props) {
    return (React.createElement(React.Suspense, { fallback: React.createElement(Loader, { size: "small" }) },
        React.createElement(CardComponent, { ...props })));
}
//# sourceMappingURL=async-card-component.js.map