import * as React from 'react';
import { triggerFieldEvent, triggerNestedFieldEvent } from '../../utils/events';
import { resolveByValue } from '../../utils/resolve-value-utils';
import { splitValueToMergedValue } from '../../utils/transformers';
import { getCommonCarbonComponentProperties, isFieldDisabled, isFieldReadOnly } from './carbon-helpers';
import { FieldLabel, HelperText } from './carbon-utility-components';
import { ReadonlyFieldBaseComponent } from './field-base-component';
import CarbonTooltip from 'carbon-react/esm/components/tooltip';
import { isNil } from 'lodash';
import { getScalePrefixPostfixFromUnit } from '../../utils/formatters';
export class CarbonWrapper extends ReadonlyFieldBaseComponent {
    constructor() {
        super(...arguments);
        this.getMappedValue = () => (this.props.map ? this.props.map(this.props.value) : (this.props.value ?? ''));
        this.onClick = async () => {
            const fieldProperties = this.props
                .fieldProperties;
            const nestedFieldsAdditionalProperties = this.props;
            const isDisabled = isFieldDisabled(this.props.screenId, fieldProperties, this.props.value, undefined);
            if (!isDisabled) {
                if (nestedFieldsAdditionalProperties.isNested) {
                    await triggerNestedFieldEvent(this.props.screenId, nestedFieldsAdditionalProperties.parentElementId || this.props.elementId, fieldProperties, 'onClick', nestedFieldsAdditionalProperties.handlersArguments?.rowValue._id, nestedFieldsAdditionalProperties.handlersArguments?.rowValue);
                }
                else {
                    await triggerFieldEvent(this.props.screenId, this.props.elementId, 'onClick');
                }
            }
        };
        this.getReadonlyValueNode = (rowValue) => {
            const readOnlyClasses = ['e-field-read-only'];
            if (this.props.nestedReadOnlyField) {
                readOnlyClasses.push('e-field-nested-no-input');
            }
            const computedUnitProperties = getScalePrefixPostfixFromUnit(this.props.screenId, this.props.locale, this.props.fieldProperties, rowValue);
            const prefix = resolveByValue({
                fieldValue: this.props.value,
                propertyValue: this.props.fieldProperties.prefix,
                rowValue,
                skipHexFormat: true,
                screenId: this.props.screenId,
            }) ?? computedUnitProperties?.prefix;
            const formattedPrefix = prefix ? `${prefix} ` : '';
            const postfix = resolveByValue({
                fieldValue: this.props.value,
                propertyValue: this.props.fieldProperties.postfix,
                rowValue,
                skipHexFormat: true,
                screenId: this.props.screenId,
            }) ??
                computedUnitProperties?.postfix ??
                '';
            const formattedPostfix = postfix ? ` ${postfix}` : '';
            return (React.createElement("span", { "data-testid": "e-field-value", className: readOnlyClasses.join(' '), onClick: this.onClick }, `${formattedPrefix}${this.getDisplayValue()}${formattedPostfix}`));
        };
    }
    getDisplayValue() {
        if (isNil(this.props.readOnlyDisplayValue)) {
            return this.getMappedValue();
        }
        return this.props.readOnlyDisplayValue;
    }
    render() {
        const carbonProps = getCommonCarbonComponentProperties(this.props);
        const rowValue = this.props.handlersArguments?.rowValue
            ? splitValueToMergedValue(this.props.handlersArguments?.rowValue)
            : undefined;
        return (React.createElement("div", { ref: this.props.componentRef, ...this.getBaseAttributesDivWrapper(this.props.componentName, this.props.className, this.props.contextType, this.props.handlersArguments?.rowValue, Boolean(this.props.isNested)) }, this.props.nestedReadOnlyField ||
            (isFieldReadOnly(this.props.screenId, this.props.fieldProperties, this.props.value, rowValue, this.props.contextType) &&
                !this.props.noReadOnlySupport) ? (React.createElement("div", null,
            (!this.props.nestedReadOnlyField || this.props.shouldRenderLabelInNestedReadOnlyMode) &&
                !this.props.fieldProperties.isTitleHidden && (React.createElement(FieldLabel, { label: this.getTitle(), htmlFor: carbonProps.id, className: this.props.shouldRenderLabelInNestedReadOnlyMode &&
                    this.props.nestedReadOnlyField
                    ? 'e-nested-read-only-label'
                    : '' })),
            React.createElement("div", null,
                this.props.readOnlyTooltip && (React.createElement(CarbonTooltip, { message: this.props.readOnlyTooltip }, this.getReadonlyValueNode(rowValue))),
                !this.props.readOnlyTooltip && this.getReadonlyValueNode(rowValue),
                !this.props.nestedReadOnlyField && (React.createElement(HelperText, { helperText: this.props.helperText || this.props.fieldProperties.helperText }))))) : (this.props.children)));
    }
}
//# sourceMappingURL=carbon-wrapper.js.map